/* lld.h - Source Code for OctaSPI FLASH Variant Type1  Low Level Driver */


/*
*  DISCLAIMER:
*
*      THIS SOFTWARE, SOURCE CODE AND ASSOCIATED MATERIALS INCLUDING BUT NOT LIMITED TO TUTORIALS,
*      GUIDES AND COMMENTARY PROVIDED WITH THIS EXERCISE ARE ONLY DESIGNED FOR REFERENCE PURPOSES
*      TO GIVE AN EXAMPLE TO LICENSEE FOR THEIR OWN NECESSARY DEVELOPMENT OF THEIR OWN SOFTWARE AND/OR
*      APPLICATION. IT IS NOT DESIGNED FOR ANY SPECIAL PURPOSE, SERIAL PRODUCTION OR USE IN MEDICAL,
*      MILITARY, AIR CRAFT, AVIATION, SPACE OF LIFE SUPPORT EQUIPMENT.
*
*      TO THE EXTENT PERMITTED BY LAW, THE EXERCISE SOFTWARE AND/OR SOURCE CODE AND/OR AND ASSOCIATED
*      MATERIALS IS PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND AND ONLY FOR REFERENCE PURPOSES.
*
*      SYNAPTIC LABORATORIES LTD. MAKES NO WARRANTIES, EITHER EXPRESS OR IMPLIED, WITH RESPECT TO THE
*      LICENSED SOFTWARE AND/OR SOURCE CODE AND/OR ASSOCIATED MATERIALS, CONFIDENTIAL INFORMATION AND
*      DOCUMENTATION PROVIDED HEREUNDER. 
*
*      SYNAPTIC LABORATORIES LTD. SPECIFICALLY DISCLAIMS THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
*      FITNESS FOR A PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT OF ANY INTELLECTUAL
*      PROPERTY RIGHT OF ANY THIRD PARTY WITH REGARD TO THE SOFTWARE, DOCUMENTATION (SCHEMATICS ETC.),
*      SOURCE CODE AND ASSOCIATED MATERIALS, CONFIDENTIAL INFORMATION AND DOCUMENTATION.
*
*      ANY USE, COMPILATION AND TESTING OF THE SOFTWARE AND/OR SOURCE CODE IS AT LICENSEE`S OWN RISK
*      AND LICENSEE IS OBLIGED TO CONDUCT EXTENSIVE TESTS TO AVOID ANY ERRORS AND FAILURE IN THE
*      COMPILED SOURCE CODE, DOCUMENTATION (SCHEMATICS ETC.) AND THE HEREFROM GENERATED SOFTWARE
*      OF LICENSEE.
*
*      EXCEPT FOR WILFULL INTENT SYNAPTIC LABORATORIES LTD. SHALL IN NO EVENT BE ENTITLED TO OR LIABLE
*      FOR ANY INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND OR NATURE, INCLUDING,
*      WITHOUT LIMITATION, BUSINESS INTERRUPTION COSTS, LOSS OF PROFIT OR REVENUE, LOSS OF DATA,
*      PROMOTIONAL OR MANUFACTURING EXPENSES, OVERHEAD, COSTS OR EXPENSES ASSOCIATED WITH WARRANTY
*      OR INTELLECTUAL PROPERTY INFRINGEMENT CLAIMS, INJURY TO REPUTATION OR LOSS OF CUSTOMERS.
*
*/

#ifndef __INC_H_SLL_NOR_FLASH_DRVRH
#define __INC_H_SLL_NOR_FLASH_DRVRH


#ifdef __cplusplus
 extern "C" {
#endif /* __cplusplus */

#include "sll_ca_xspi_mc_init.h"

/*Define Version */
#define SLL_NOR_FLASH_DRVR_VERSION  "22.1.1"   //  Year.Quarter.Minor
 
 /*Supports  Cypress Semper Flash    MX35XU    Devices */
 /*Supports  Micron  Flash   MX35XU    Devices */
 /*Supports  ISSI    Flash   IS35O     Devices */
 /*Supports  GigaDevice Flash GD55LX    Devices */


//------------------------------------------------
/* Controller Parameters   */  
//------------------------------------------------
typedef struct{
    uint32_t xspi_mbmc_status_rd_cmd;
    uint32_t xspi_mbmc_reg_rd_cmd;
    uint32_t xspi_mbmc_sfpd_rd_cmd;

    uint16_t status_rd_cmd;
    uint16_t flag_status_rd_cmd;
    uint16_t id_rd_cmd;
    uint16_t sfpd_rd_cmd;
    uint16_t any_reg_rd_cmd;
    uint16_t any_nvreg_rd_cmd;
    uint16_t reset_cmd;
    uint16_t reset_en_cmd;
    uint16_t wren_cmd;
    uint16_t sector_4k_erase_cmd;
    uint16_t sector_erase_cmd;
    uint16_t bulk_erase_cmd;
    uint16_t bulk_wr_cmd;
    uint16_t nop_cmd;
    uint16_t any_reg_wr_cmd;
    uint16_t any_nvreg_wr_cmd;

    uint16_t flash_dev_ready_mask;
    uint16_t flash_dev_ready;
    uint16_t flash_dev_erase_mask;
    uint16_t flash_dev_program_mask;

    uint16_t flash_dev_flag_sec_lock_mask;
    uint16_t flash_dev_flag_program_mask;
    uint16_t flash_dev_flag_erase_mask;
    uint16_t flash_dev_flag_erase_susp_mask;
    uint16_t flash_dev_flag_ready_mask;
    uint16_t flash_dev_flag_ready;

    uint16_t use_flg_status_register;
    uint16_t use_flg2_status_register;

} Flash_Info;


/**
 *  Description of the Flash Devie controller
 */
typedef struct sll_xspi_flash_dev
{
    /* Flash common declaration */
    Flash_Info dev;

    /* IP specific information */
    char name[16];
    uint32_t csr_base;
    uint32_t data_base; /** base address of data slave */
    uint32_t data_end; /** end address of data slave (not inclusive) */
    uint32_t size_in_bytes; /** size of memory in bytes */
    uint32_t number_of_sectors; /** number of flash sectors */
    uint32_t sector_size; /** size of each flash sector */
    uint32_t page_size; /** page size */

} sll_xspi_flash_dev;


#define NOR_FLASH_SECTOR_4K   (  4*1024)


/* polling return status */
typedef enum {
 NOR_DEV_IS_IDLE,
 NOR_DEV_EMPTY_COUNT,
 NOR_DEV_WRITE_BUFFER_OVERFLOW,
 NOR_DEV_ERASE_ERROR,           /* Device Erase error */
 NOR_DEV_PROGRAM_ERROR,         /* Device Program error */
 NOR_DEV_LOCKED_SECTOR          /* Device sector is locked */ 
} NOR_DEV_STATUS;


/* public function prototypes */

extern void sll_nor_flash_dev_int
(
xSPI_MBMC_Info *inst  ,        /* Flash device*/
sll_xspi_flash_dev *fd       /* Flash device*/
);


extern NOR_DEV_STATUS sll_nor_flash_drvr_WriteBufferProgramOp
(
sll_xspi_flash_dev *fd ,      /* Flash device*/
uint32_t  offset,         /* address offset from base address (byte aligned) */
uint32_t  byte_count,     /* number of bytes to program */
uint32_t *data_buf       /* buffer containing data to program */
);


extern NOR_DEV_STATUS sll_nor_flash_drvr_ProgramOp
(
sll_xspi_flash_dev *fd ,      /* Flsh device*/
uint32_t offset,         /* address offset from base address (byte aligned) */
uint32_t write_data      /* variable containing data to program */
);


extern NOR_DEV_STATUS sll_nor_flash_drvr_Sector4kEraseOp
(
sll_xspi_flash_dev *fd ,      /* Flash device*/
uint32_t offset          /* address offset from base address (byte aligned) */
);

extern NOR_DEV_STATUS sll_nor_flash_drvr_SectorEraseOp
(
sll_xspi_flash_dev *fd ,      /* Flash device*/
uint32_t offset          /* address offset from base address (byte aligned) */
);


extern void sll_nor_flash_drvr_ResetCmd
(
sll_xspi_flash_dev *fd       /* Flash device*/
);


NOR_DEV_STATUS sll_nor_flash_drvr_memcpy
(
sll_xspi_flash_dev *fd ,      /* Flash device*/
uint32_t offset,         /* address offset from base address (byte aligned) */
uint32_t byte_count,     /* number of byte_count to program */
uint32_t *data_buf      /* buffer containing data to program */
);


extern uint32_t sll_nor_flash_drvr_Poll
(
sll_xspi_flash_dev *fd ,      /* Flash device*/
uint32_t offset          /* address offset from base address (byte aligned) */
);

extern uint32_t sll_nor_flash_drvr_GetDeviceId
(
sll_xspi_flash_dev *fd       /* Flash device*/
);


extern uint32_t sll_nor_flash_drvr_GetStatus
(
sll_xspi_flash_dev *fd       /* Flash device*/
);


extern uint32_t sll_nor_flash_drvr_GetFlagStatus
(
sll_xspi_flash_dev *fd       /* Flash device*/
);



extern uint32_t sll_nor_flash_drvr_ReadAnyReg
(
sll_xspi_flash_dev *fd ,      /* Flash device*/
uint32_t offset      /* register address */
);


extern void sll_nor_flash_drvr_ReadCFI
(
sll_xspi_flash_dev *fd ,      /* Flash device*/
uint32_t *data_buf      /* buffer containing data to program */
);



extern void sll_nor_flash_drvr_WriteAnyReg
(
sll_xspi_flash_dev *fd ,      /* Flash device*/
uint32_t offset,     /* register address */
uint32_t data        /* 32-bit data to be written */
);


extern void sll_nor_flash_drvr_WriteAnyReg_x16
(
sll_xspi_flash_dev *fd ,      /* Flash device*/
uint32_t offset,     /* register address */
uint16_t data        /* 16-bit data to be written */
);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __INC_H_SLL_NOR_FLASH_DRVRH  */


